import com.ms.wfc.app.*;
import com.ms.wfc.core.*;
import com.ms.wfc.ui.*;
import com.ms.wfc.html.*;
import cnrg.itx.ds.*;

/**
 * This class can take a variable number of parameters on the command
 * line. Program execution begins with the main() method. The class
 * constructor is not invoked unless an object of type 'EditUser'
 * created in the main() method.
 */
public class EditUser extends Form { 
	
	private Password m_password;
	private UserID m_id;
	private DirectoryService m_ds;
	
	public EditUser(UserID p_id, Password p_password)
	{
		super();

		// Required for Visual J++ Form Designer support
		initForm();		

		// TODO: Add any constructor code after initForm call
		m_password = p_password;
		m_id = p_id;
		this.setText(m_id.toString());
		
		try {
			m_ds = new DirectoryService();
			m_ds.declareIdentity(m_id, m_password);
		
			LocationList lList = m_ds.getLocationListByID(m_id);
			Location g = lList.first();
			while(g!=null) {
				listBoxLocations.addItem(g);
				listBoxLocations.setSelectedItem(g);
				g = lList.next();
			}
			if(listBoxLocations.getSelectedItem() == null)
				button1.setEnabled(false);
		} catch (DirectoryServiceException de) {
			this.setDialogResult(DialogResult.ABORT);
		}
	}

	/**
	 * EditUser overrides dispose so it can clean up the
	 * component list.
	 */
	public void dispose()
	{
		super.dispose();
		components.dispose();
		m_ds = null;
		m_password = null;
		m_id = null;
	}
	
	private void button1_click(Object source, Event e) {
		Object[] templist = listBoxLocations.getSelectedItems();
		for(int i = 0; i<templist.length; i++) 
		{
			Location l = (Location)templist[i];
			try {
				m_ds.unregisterLocation(Location.DYNAMIC, l);
				listBoxLocations.removeItem(l);
			} catch (DirectoryServiceException dse) {
				return;
			}
		}
	}

	/**
	 * NOTE: The following code is required by the Visual J++ form
	 * designer.  It can be modified using the form editor.  Do not
	 * modify it using the code editor.
	 */
	Container components = new Container();
	Button button1 = new Button();
	ListBox listBoxLocations = new ListBox();
	GroupBox groupBox1 = new GroupBox();

	private void initForm()
	{
		// NOTE:  This form is storing resource information in an
		// external file.  Do not modify the string parameter to any
		// resources.getObject() function call. For example, do not
		// modify "foo1_location" in the following line of code
		// even if the name of the Foo object changes: 
		//   foo1.setLocation((Point)resources.getObject("foo1_location"));

		IResourceManager resources = new ResourceManager(this, "EditUser");
		this.setText("");
		this.setAutoScaleBaseSize(new Point(5, 13));
		this.setBorderStyle(FormBorderStyle.FIXED_SINGLE);
		this.setClientSize(new Point(371, 460));
		this.setIcon((Icon)resources.getObject("this_icon"));
		this.setMaximizeBox(false);
		this.setStartPosition(FormStartPosition.CENTER_SCREEN);

		button1.setLocation(new Point(232, 24));
		button1.setSize(new Point(96, 32));
		button1.setTabIndex(1);
		button1.setText("unregister");
		button1.addOnClick(new EventHandler(this.button1_click));

		listBoxLocations.setLocation(new Point(8, 24));
		listBoxLocations.setSize(new Point(200, 238));
		listBoxLocations.setTabIndex(0);
		listBoxLocations.setText("listBox1");
		listBoxLocations.setSelectionMode(SelectionMode.MULTI_SIMPLE);
		listBoxLocations.setUseTabStops(true);

		groupBox1.setLocation(new Point(8, 80));
		groupBox1.setSize(new Point(352, 280));
		groupBox1.setTabIndex(0);
		groupBox1.setTabStop(false);
		groupBox1.setText("Locations");

		this.setNewControls(new Control[] {
							groupBox1});
		groupBox1.setNewControls(new Control[] {
								 button1, 
								 listBoxLocations});
	}

}
